!Object constantsFor: 'Geos Libraries'!

geosLIB71 'SYSTEM\sound'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

SoundGetExclusive
	"void pascal SoundGetExclusive(void) in sound.h"
	^GEOS call: #[71 0 37 0]!

SoundGetExclusiveNB
	"Boolean pascal SoundGetExclusiveNB(void) in sound.h"
	^GEOS call: #[71 0 38 4]!

SoundReleaseExclusive
	"void pascal SoundReleaseExclusive(void) in sound.h"
	^GEOS call: #[71 0 39 0]!

SoundAllocMusic: song with: voices with: control
	"word pascal SoundAllocMusic(const word *song, word voices, MemHandle *control) in sound.h"
	^GEOS call: song with: voices with: control with: #[71 0 40 3 1 3 1]!

SoundPlayMusic: mh with: priority with: tempo with: flags
	"word pascal SoundPlayMusic(MemHandle mh, word priority, word tempo, EndOfSongFlags flags) in sound.h"
	^GEOS call: mh with: priority with: tempo with: flags with: #[71 0 41 1 1 1 1 1]!

SoundStopMusic: mh
	"word pascal SoundStopMusic(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 42 1 1]!

SoundPlayMusicLMem: mh with: priority with: tempo with: flags
	"word pascal SoundPlayMusicLMem(MemHandle mh, word priority, word tempo, EndOfSongFlags flags) in sound.h"
	^GEOS call: mh with: priority with: tempo with: flags with: #[71 0 96 1 1 1 1 1]!

SoundStopMusicLMem: mh
	"word pascal SoundStopMusicLMem(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 97 1 1]!

SoundReallocMusic: mh with: song
	"word pascal SoundReallocMusic(MemHandle mh, const word *song) in sound.h"
	^GEOS call: mh with: song with: #[71 0 43 1 3 1]!

SoundReallocMusicLMem: mh with: song
	"word pascal SoundReallocMusicLMem(MemHandle mh, optr song) in sound.h"
	^GEOS call: mh with: song with: #[71 0 100 1 2 1]!

SoundFreeMusic: mh
	"void pascal SoundFreeMusic(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 44 1 0]!

SoundInitMusic: mh with: voices
	"void pascal SoundInitMusic(MemHandle mh, word voices) in sound.h"
	^GEOS call: mh with: voices with: #[71 0 61 1 1 0]!

SoundAllocMusicNote: instrument with: instTable with: frequency with: volume with: DeltaType with: duration with: control
	"word pascal SoundAllocMusicNote(InstrumentPatch instrument, word instTable, word frequency, word volume, SoundStreamDeltaTimeType DeltaType, word duration, MemHandle *control) in sound.h"
	^GEOS call: instrument with: instTable with: frequency with: volume with: DeltaType with: duration with: control with: #[71 0 45 1 1 1 1 1 1 3 1]!

SoundPlayMusicNote: mh with: priority with: tempo with: flags
	"word pascal SoundPlayMusicNote(MemHandle mh, SoundPriority priority, word tempo, EndOfSongFlags flags) in sound.h"
	^GEOS call: mh with: priority with: tempo with: flags with: #[71 0 46 1 1 1 1 1]!

SoundStopMusicNote: mh
	"word pascal SoundStopMusicNote(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 47 1 1]!

SoundReallocMusicNote: mh with: freq with: vol with: timer with: durat with: instrument with: instTable
	"word pascal SoundReallocMusicNote(MemHandle mh, word freq, word vol, SoundStreamDeltaTimeType timer, word durat, InstrumentPatch instrument, word instTable) in sound.h"
	^GEOS call: mh with: freq with: vol with: timer with: durat with: instrument with: instTable with: #[71 0 48 1 1 1 1 1 1 1 1]!

SoundFreeMusicNote: mh
	"void pascal SoundFreeMusicNote(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 49 1 0]!

SoundAllocMusicStream: streamSize with: priority with: voices with: tempo with: control
	"word pascal SoundAllocMusicStream(SoundStreamSize streamSize, SoundPriority priority, word voices, word tempo, MemHandle *control) in sound.h"
	^GEOS call: streamSize with: priority with: voices with: tempo with: control with: #[71 0 50 1 1 1 1 3 1]!

SoundPlayToMusicStream: mh with: song with: size
	"word pascal SoundPlayToMusicStream(MemHandle mh, const word *song, word size) in sound.h"
	^GEOS call: mh with: song with: size with: #[71 0 51 1 3 1 1]!

SoundPlayToMusicStreamNB: mh with: song with: size with: bytesWritten
	"word pascal SoundPlayToMusicStreamNB(MemHandle mh, const word *song, word size, word *bytesWritten) in sound.h"
	^GEOS call: mh with: song with: size with: bytesWritten with: #[71 0 98 1 3 1 3 1]!

SoundStopMusicStream: mh
	"word pascal SoundStopMusicStream(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 52 1 1]!

SoundFreeMusicStream: mh
	"void pascal SoundFreeMusicStream(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 53 1 0]!

SoundAllocSampleStream: control
	"word pascal SoundAllocSampleStream(MemHandle *control) in sound.h"
	^GEOS call: control with: #[71 0 54 3 1]!

SoundEnableSampleStream: mh with: priority with: rate with: manufacturerID with: sampleFormat
	"word pascal SoundEnableSampleStream(MemHandle mh, SoundPriority priority, word rate, word manufacturerID, DACSampleFormat sampleFormat) in sound.h"
	^GEOS call: mh with: priority with: rate with: manufacturerID with: sampleFormat with: #[71 0 56 1 1 1 1 1 1]!

SoundDisableSampleStream: mh
	"void pascal SoundDisableSampleStream(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 57 1 0]!

SoundPlayToSampleStream: mh with: sample with: size with: format
	"word pascal SoundPlayToSampleStream(MemHandle mh, const word *sample, word size, const SampleFormatDescription *format) in sound.h"
	^GEOS call: mh with: sample with: size with: format with: #[71 0 55 1 3 1 3 1]!

SoundFreeSampleStream: mh
	"void pascal SoundFreeSampleStream(MemHandle mh) in sound.h"
	^GEOS call: mh with: #[71 0 58 1 0]!

SoundChangeOwnerSimple: mh with: owner
	"void pascal SoundChangeOwnerSimple(MemHandle mh, MemHandle owner) in sound.h"
	^GEOS call: mh with: owner with: #[71 0 60 1 1 0]!

SoundChangeOwnerStream: mh with: owner
	"void pascal SoundChangeOwnerStream(MemHandle mh, MemHandle owner) in sound.h"
	^GEOS call: mh with: owner with: #[71 0 59 1 1 0]!

SoundSynthDriverInfo: voices with: format with: capability
	"void pascal SoundSynthDriverInfo(word *voices, SupportedEnvelopeFormat *format, SoundDriverCapability *capability) in sound.h"
	^GEOS call: voices with: format with: capability with: #[71 0 62 3 3 3 0]!

SoundSampleDriverInfo: voices with: capability
	"void pascal SoundSampleDriverInfo(word *voices, SoundDriverCapability *capability) in sound.h"
	^GEOS call: voices with: capability with: #[71 0 63 3 3 0]!

SoundVoiceManagerGetFree: priority
	"word pascal SoundVoiceManagerGetFree(SoundPriority priority) in sound.h"
	^GEOS call: priority with: #[71 0 64 1 1]!

SoundVoiceManagerFree: voice
	"void pascal SoundVoiceManagerFree(word voice) in sound.h"
	^GEOS call: voice with: #[71 0 65 1 0]!

SoundDACManagerGetFree: priority
	"word pascal SoundDACManagerGetFree(SoundPriority priority) in sound.h"
	^GEOS call: priority with: #[71 0 69 1 1]!

SoundDACManagerFree: voice
	"void pascal SoundDACManagerFree(word voice) in sound.h"
	^GEOS call: voice with: #[71 0 70 1 0]!

!

